<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
        "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="en" xml:lang="en">
<head>
<title>Line Graph: Canvas IE8</title>
<meta http-equiv="X-UA-Compatible" content="IE=7" />
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<style type="text/css">
#graph
{
   width: 800px;
   margin: 50px auto;
}
</style>
<script type="text/javascript" src="excanvassl.js">
</script>

<script type="text/javascript">
//<![CDATA[

<?php

$row = 1;
$handle = fopen("comments.csv", "r");
$cts = fread($handle, 1000);
fclose($handle);

if ($cts) {
   print("var points = new Array($cts);");
}
?>

window.onload = function() {
   var canvas = document.getElementById("graphcanvas");
   if (canvas.getContext) {
      var ctx = canvas.getContext("2d");

      // blue background
      ctx.fillStyle="#000066";
      ctx.fillRect(0,0,800,200);

      // create line graph
      var startx = 0; starty = 150; 
      ctx.strokeStyle = "#ff0"; 
      ctx.lineWidth="2";
      for (var i = 0; i < points.length; i++) {
        ctx.moveTo(startx, starty);
        startx+=8;
        starty=150 - (points[i] * 2);
        ctx.lineTo(startx,starty);
      }

      // write out the line
      ctx.stroke();
   }
}
//]]>

</script>
</head>
<body>
<div id="graph">
<canvas id="graphcanvas" width="800" height="200"></canvas>
</div>
</body>
</html>
